/*
 * Decompiled with CFR 0.152.
 */
package com.tino1b2be.cmdprograms;

import com.tino1b2be.audio.AudioFileException;
import com.tino1b2be.audio.WavFileException;
import com.tino1b2be.cmdprograms.AudioTestResult;
import com.tino1b2be.dtmfdecoder.DTMFDecoderException;
import com.tino1b2be.dtmfdecoder.DTMFUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class AudioTestThread
extends Thread {
    private ArrayList<File> files;
    private int start;
    private AudioTestResult[] results;

    public AudioTestThread(ArrayList<File> fileList, AudioTestResult[] results, int start) {
        this.files = fileList;
        this.start = start;
        this.results = results;
    }

    @Override
    public void run() {
        try {
            this.sequentialRun();
        }
        catch (WavFileException | DTMFDecoderException | IOException e) {
            e.printStackTrace();
        }
        catch (AudioFileException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sequentialRun() throws AudioFileException, Exception {
        int i = this.start;
        for (File file : this.files) {
            DTMFUtil dtmf = new DTMFUtil(file);
            dtmf.decode();
            String decoded = dtmf.getDecoded()[0];
            this.results[i++] = new AudioTestResult(file, decoded);
        }
    }
}

